;******************** (C) COPYRIGHT 2005 STMicroelectronics ********************
;* File Name          : 73x_init.s
;* Author             : MCD Application Team
;* Date First Issued  : 09/27/2005 
;* Description        : This module performs:
;*                      - FLASH/RAM remapping (if required),
;*                      - Stack pointer initialisation for each mode,
;*                      - Interrupt Controller Initialisation,
;*                      - Branches to ?main in the C library
;*                        (which eventually calls main()).
;*
;*			On reset, the ARM core starts up in Supervisor (SVC) mode,
;*			in ARM state,with IRQ and FIQ disabled.
;*********************************************************************************
; History:
; 09/15/2006 : IAP Version 3.0
;*********************************************************************************
; THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
; CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
; AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
; OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
; OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
; CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
;********************************************************************************/

	
        IMPORT PRCCUCMU_Addr	
        EXPORT ARMIRQ_Enable
        EXPORT ARMFIQ_Enable	
        EXPORT ARMIRQ_Disable
        EXPORT ARMFIQ_Disable	

 ; Depending in Your Application, Disable or Enable the Following Defines

;#define   FLASH_RAM_REMAP  ; Remap RAM at Address 0x0
#define   EIC_INIT         ; Configure and Initialize EIC

; --- Standard definitions of mode bits and interrupt (I & F) flags in PSRs
Mode_USR           EQU    0x10
Mode_FIQ           EQU    0x11
Mode_IRQ           EQU    0x12
Mode_SVC           EQU    0x13
Mode_ABT           EQU    0x17
Mode_UND           EQU    0x1B
Mode_SYS           EQU    0x1F 

I_Bit              EQU    0x80 ; when I bit is set, IRQ is disabled
F_Bit              EQU    0x40 ; when F bit is set, FIQ is disabled


; --- System memory locations

CFG_R0_Addr         EQU    0x40000000   ; Configuration Register 0 base address
CFG_PCGR0_Addr      EQU    0x40000008



;---------------------------------------------------------------
; ?program_start
;---------------------------------------------------------------
		MODULE	?program_start
		RSEG	IRQ_STACK:DATA(2)
		RSEG	FIQ_STACK:DATA(2)
		RSEG	UND_STACK:DATA(2)
		RSEG	ABT_STACK:DATA(2)		
		RSEG	SVC_STACK:DATA(2)
		RSEG	CSTACK:DATA(2)
		RSEG	ICODE:CODE(2)
		PUBLIC	__program_start
		EXTERN	?main
                CODE32

__program_start
e        LDR     pc, =NextInst

NextInst


        NOP   ; Wait for OSC stabilization
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        


        ; Reset all Peripheral Clocks except RAM
        ; This is usefull only when using debugger to Reset\Run the application

        MOV r0,#1
        LDR r1,=CFG_PCGR0_Addr
        STR r0,[r1]
        MOV r0,#0
        STR r0,[r1,#4]

 ; --- Initialize stack pointer registers

 ; Enter each mode in turn and set up the stack pointer


        MSR     CPSR_c, #Mode_FIQ|I_Bit|F_Bit        ; No interrupts
        ldr      sp,=SFE(FIQ_STACK) & 0xFFFFFFF8     ; End of FIQ_STACK

        MSR     CPSR_c, #Mode_IRQ|I_Bit|F_Bit        ; No interrupts
        ldr     sp,=SFE(IRQ_STACK) & 0xFFFFFFF8      ; End of IRQ_STACK

        MSR     CPSR_c, #Mode_ABT|I_Bit|F_Bit        ; No interrupts
        ldr     sp,=SFE(ABT_STACK) & 0xFFFFFFF8      ; End of ABT_STACK

        MSR     CPSR_c, #Mode_UND|I_Bit|F_Bit        ; No interrupts
        ldr     sp,=SFE(UND_STACK) & 0xFFFFFFF8      ; End of UND_STACK

        MSR     CPSR_c, #Mode_SVC|I_Bit|F_Bit        ; No interrupts
        ldr     sp,=SFE(SVC_STACK) & 0xFFFFFFF8      ; End of SVC_STACK


#ifdef  FLASH_RAM_REMAP

  ; FLASH_RAM_REMAP
  ; -------------------------------------------------------------------------------
  ; Description  :   On reset, an aliased copy of FLASH  is at 0x0.
  ;                  Perform FLASH/RAM remapping, if required in order to have
  ;                  an aliased copy of RAM at 0x0
  ; -------------------------------------------------------------------------------

        LDR     r1, =CFG_R0_Addr
        LDR     r0, [r1]
        ORR     r0, r0, #0x1
        STR     r0, [r1]
#endif

; RAM is now at 0x0.
; The exception vectors (in 73x_vect.s) must be copied from FLASH to the RAM
; The copying is done later by the C library code inside ?main




; --- Now change to USR/SYS mode and set up User mode stack,

        MSR     CPSR_c, #Mode_SYS                 ; IRQs & FIQs are now enabled
        ldr     sp,=SFE(CSTACK) & 0xFFFFFFF8        ; End of CSTACK



; --- Branch to C Library entry point
        B       ?main   ;  use B not BL, because an application will never return this way


; --- The following functions are exported to the EIC configuration file
; --- and may be used by application whenever they are needed


ARMIRQ_Disable:      ; Disable the ARM7 core IRQ line.

 MRS  r0,CPSR
 ORR  r0, r0, #I_Bit	
 MSR  CPSR_c, r0
 BX lr



ARMFIQ_Disable:      ; Disable the ARM7 core FIQ line.

 MRS  r0,CPSR
 ORR  r0, r0, #F_Bit	
 MSR  CPSR_c, r0
 BX lr




ARMIRQ_Enable:       ; Enable the ARM7 core IRQ line.

 MRS  r0,CPSR
 BIC  r0, r0,#I_Bit	
 MSR  CPSR_c, r0
 BX lr





ARMFIQ_Enable:       ; Enable the ARM7 core FIQ line.

 MRS  r0,CPSR
 BIC  r0, r0,#F_Bit	
 MSR  CPSR_c, r0
 BX lr

        LTORG

        
        END
;******************* (C) COPYRIGHT 2005 STMicroelectronics *****END OF FILE****
